#include <bits/stdc++.h>

using namespace std;

const long long INF = 2e18;

void solve(){
    int n, m;

    cin >> n >> m;

    vector<vector<int>> a, b;

    a = b = vector<vector<int>>(n, vector<int>(m, 0));

    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cin >> a[i][j];
        }
    }

    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cin >> b[i][j];
        }
    }

    vector<array<int, 3>> edges;

    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            // a_ij <= x_i - x_{n+j} <= b_ij
            // x_i - x_{n+j} <= b_ij
            // x_{n+j} - x_i <= -a_ij

            edges.push_back({n + j, i, b[i][j]});
            edges.push_back({i, n + j, -a[i][j]});
        }
    }

    vector<long long> dist(n + m, -INF);
    dist[0] = 0;

    for(int it = 0; it < n + m; it++){
        bool changed = false;

        for(int i = 0; i < edges.size(); i++){
            if(dist[edges[i][0]] + edges[i][2] < dist[edges[i][1]]){
                dist[edges[i][1]] = dist[edges[i][0]] + edges[i][2];
                changed = true;
            }
        }

        if(!changed) break;
        else if(it == n + m - 1){
            cout << "HAYIR\n";
            return;
        }
    }

    vector<vector<int>> h(n, vector<int>(m, 0));

    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            h[i][j] = dist[i] - dist[n + j];
        }
    }

    cout << "EVET\n";

    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cout << h[i][j] << " ";
        }
        cout << '\n';
    }
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;
    while(t--) solve();
}